<?php // JG 5/14/13 part 1 - set a session ID cookie and and empty cart
include_once $_SERVER['DOCUMENT_ROOT'] .
    '/includes/magicquotes.inc.php';

$items = array(
    array('id' => '1', 'desc' => 'Canadian-Australian Dictionary',
        'price' => 24.95),
    array('id' => '2', 'desc' => 'As-new parachute (never opened)',
        'price' => 1000),
    array('id' => '3', 'desc' => 'Songs of the Goldfish (2CD set)',
        'price' => 19.99),
    array('id' => '4', 'desc' => 'Simply JavaScript (SitePoint)',
        'price' => 39.95));

session_start();  //JG 5/14/13 set the session ID cookie
if (!isset($_SESSION['cart']))
{
  $_SESSION['cart'] = array(); //JG 5/14/13 initialize to the empty array to represent the empty cart
}
// JG 5/14/13 part II - Buy an item
if (isset($_POST['action']) and $_POST['action'] == 'Buy')
{
  // Add item to the end of the $_SESSION['cart'] array
  $_SESSION['cart'][] = $_POST['id']; //JG id is from catalog.html.php
  header('Location: .');
  exit();
}
// JG 5/14/13 part III - Empty cart
if (isset($_POST['action']) and $_POST['action'] == 'Empty cart')
{
  // Empty the $_SESSION['cart'] array
  unset($_SESSION['cart']); // JG 5/14/13 set empty variables
  header('Location: ?cart'); // JG 5/14/13 run cart.html.php
  exit();
}
// JG 5/14/13 part IV - the user clicks "View your cart" in catalog.html.php, the code was: <a href="?cart">View your cart</a>
if (isset($_GET['cart']))
{
  $cart = array();
  $total = 0;
  foreach ($_SESSION['cart'] as $id)
  {
    foreach ($items as $product)
    {
      if ($product['id'] == $id) //search through the $items array 
	             // looking for a produt whose ID $product['id'] == $id
      {
        $cart[] = $product;
        $total += $product['price'];
        break;  // JG 5/14/13 found so, stop executing, go to next id
      }
    }
  }

  include 'cart.html.php';
  exit();
}
// JG 5/14/13 Display a catalog - Continue shopping
include 'catalog.html.php';
