<?php
namespace Ijdb\Controllers;
use \Ninja\DatabaseTable;

class Joke {
	private $authorsTable;
	private $jokesTable;

	public function __construct(DatabaseTable $jokesTable, DatabaseTable $authorsTable) {
		$this->jokesTable = $jokesTable;
		$this->authorsTable = $authorsTable;
	}

	public function list() {
		$result = $this->jokesTable->findAll();

		$jokes = [];
		foreach ($result as $joke) {
			$author = $this->authorsTable->findById($joke['authorId']);

			$jokes[] = [
				'id' => $joke['id'],
				'joketext' => $joke['joketext'],
				'jokedate' => $joke['jokedate'],
				'name' => $author['name'],
				'email' => $author['email']
			];

		}


		$title = 'Joke list';

		$totalJokes = $this->jokesTable->total();

		ob_start();

		include  __DIR__ . '/../../templates/';

		$output = ob_get_clean();

		return ['template' => 'jokes.html.php', 
				'title' => $title, 
				'variables' => [
						'totalJokes' => $totalJokes,
						'jokes' => $jokes
					]
				];
	}

	public function home() {
		$title = 'Internet Joke Database';

		return ['template' => 'home.html.php', 'title' => $title];
	}

	public function delete() {
		$this->jokesTable->delete($_POST['id']);

		//header('location: /joke/list'); 5/21/18 JG DEL1  org
		header('location: index.php?joke/list');  // 5/21/18 JG NEW1  
	}

	public function saveEdit() {
		$joke = $_POST['joke'];
		$joke['jokedate'] = new \DateTime();
		$joke['authorId'] = 1;

		$this->jokesTable->save($joke);
		
		//header('location: /joke/list'); 5/21/18 JG DEL1  org
		header('location: index.php?joke/list');  //5/21/18 JG NEW1  
	}

	public function edit() {
		if (isset($_GET['id'])) {
			$joke = $this->jokesTable->findById($_GET['id']);
			print ('joke.php: 80 id = ' . $_GET['id'] . '<br>');  // test
		}

		
		$title = 'Edit joke';

		return ['template' => 'editjoke.html.php',
				'title' => $title,
				'variables' => [
						'joke' => $joke ?? null
					]
				];
	}
	
}