<?php
    // 5/12/16 JG check if the user has already logged in or submitted the form with a correct email and password
function userIsLoggedIn()
{
  if (isset($_POST['action']) and $_POST['action'] == 'login')
  {
    if (!isset($_POST['email']) or $_POST['email'] == '' or
      !isset($_POST['password']) or $_POST['password'] == '')
    {
      $GLOBALS['loginError'] = 'Please fill in both fields';
      return FALSE;
    }

    $password = md5($_POST['password'] . 'ijdb');

    if (databaseContainsAuthor($_POST['email'], $password))
    {
      //5/12/16 JG: sets the sessions ID cookies or restored the variables registered in the existing session
	  session_start();
      //5/12/16 JG: more secure email and password in addition to just a flag, since we can check credentials every time a sensitive page is requested 
	  $_SESSION['loggedIn'] = TRUE; 
      $_SESSION['email'] = $_POST['email'];
      $_SESSION['password'] = $password;
      return TRUE;
    }
    else
    {
      session_start();
	   // 5/12/16 JG Remove 3 variables
      unset($_SESSION['loggedIn']);
      unset($_SESSION['email']);
      unset($_SESSION['password']);
      $GLOBALS['loginError'] =
          'The specified email address or password was incorrect.';
      return FALSE;
    }
  }

  if (isset($_POST['action']) and $_POST['action'] == 'logout')
  {
    session_start();
    unset($_SESSION['loggedIn']);
    unset($_SESSION['email']);
    unset($_SESSION['password']);
    header('Location: ' . $_POST['goto']); // value="/admin/"
    exit();
  }
       //5/12/16 JG: if neither above cases detected check if
	   //the user is logged in using the sessions variables
  session_start();  
	//5/12/16 JG: sets the sessions ID cookies or restored the variables registered in the existing session  
  if (isset($_SESSION['loggedIn']))
  {
    return databaseContainsAuthor($_SESSION['email'], $_SESSION['password']);
  }
}   // end function userIsLoggedIn()

function databaseContainsAuthor($email, $password)
{
  include 'db.inc.php';

  try
  {
    $sql = 'SELECT COUNT(*) FROM author
        WHERE email = :email AND password = :password';
    $s = $pdo->prepare($sql);
    $s->bindValue(':email', $email);
    $s->bindValue(':password', $password);
    $s->execute();
  }
  catch (PDOException $e)
  {
    $error = 'Error searching for author.';
    include 'error.html.php';
    exit();
  }

  $row = $s->fetch();

  if ($row[0] > 0)
  {
    return TRUE;
  }
  else
  {
    return FALSE;
  }
}  // end databaseContainsAuthor($email, $password)
     
	 // 5/12/16 JG check if the user has been assigned the specific role
function userHasRole($role)   
{
  include 'db.inc.php';

  try
  {
    $sql = "SELECT COUNT(*) FROM author
        INNER JOIN authorrole ON author.id = authorid
        INNER JOIN role ON roleid = role.id
        WHERE email = :email AND role.id = :roleId";
    $s = $pdo->prepare($sql);
    $s->bindValue(':email', $_SESSION['email']);
    $s->bindValue(':roleId', $role);
    $s->execute();
  }
  catch (PDOException $e)
  {
    $error = 'Error searching for author roles.';
    include 'error.html.php';
    exit();
  }

  $row = $s->fetch();

  if ($row[0] > 0)
  {
    return TRUE;
  }
  else
  {
    return FALSE;
  }
} // end userHasRole($role)
