<?php
namespace Ijdb\Controllers;
use \Ninja\DatabaseTable;
     //#N1 5/8/22 A.Flores NEW 1L: import class Authentication
use \Ninja\Authentication;

class Joke {
	private $authorsTable;
	private $jokesTable;
         //#P1 5/8/22 A.Flores NEW 5L: A constructor to the Joke class that sets the $authorsTable, $jokesTable, and $authentication variables
	public function __construct(DatabaseTable $jokesTable, DatabaseTable $authorsTable, Authentication $authentication) {
		$this->jokesTable = $jokesTable;
		$this->authorsTable = $authorsTable;
		     //#N2 5/8/22 A.Flores NEW 1L: sets $authentication
		$this->authentication = $authentication;
	}
         //#P2 5/8/22 A.Flores NEW 3L: function list() uses findAll() function and foreach loop to store joke information to be display on jokes.html.php and gets user user information.
	public function list() {
		$result = $this->jokesTable->findAll();

		$jokes = [];
		foreach ($result as $joke) {
			$author = $this->authorsTable->findById($joke['authorId']);

			$jokes[] = [
				'id' => $joke['id'],
				'joketext' => $joke['joketext'],
				'jokedate' => $joke['jokedate'],
				'name' => $author['name'],
				'email' => $author['email'],
					 //#N3 5/8/22 A.Flores NEW 1L: added authorId value
				'authorId' => $author['id']
			];

		}


		$title = 'Joke list';

		$totalJokes = $this->jokesTable->total();
	         //#N4 5/8/22 A.Flores NEW 1L: call getUser() method to get user's information
		$author = $this->authentication->getUser();

		return ['template' => 'jokes.html.php', 
				'title' => $title, 
				'variables' => [
						'totalJokes' => $totalJokes,
						'jokes' => $jokes,
						'userId' => $author['id'] ?? null
					]
				];
	}
         //#P3 5/8/22 A.Flores NEW 5L: home() function is use return template value and title for homepage 
	public function home() {
		$title = 'Internet Joke Database';

		return ['template' => 'home.html.php', 'title' => $title];
	}
		 //#P4 5/8/22 A.Flores NEW 15L: delete() calls the delete() function from DatabaseTable.php and reloads page to display results
	public function delete() {
	          //#N5 5/8/22 A.Flores NEW 5L: get user's author Id and author joke id to compare them. If they are equal, then delete joke
		$author = $this->authentication->getUser();

		$joke = $this->jokesTable->findById($_POST['id']);

		if ($joke['authorId'] != $author['id']) {
			return;
		}
		
		
		$this->jokesTable->delete($_POST['id']);
        //header('location: /joke/list'); 5/25/18 JG DEL1L  org
		header('location: index.php?joke/list');  // 5/25/18 JG NEW1L  		
	}
		 //#P5 5/8/22 A.Flores NEW 21L: SaveEdit() method is use to save edited jokes by calling save() method from DatabaseTable.php
	public function saveEdit() {
		     //#N6 5/8/22 A.Flores NEW 1L: get author's information 
		$author = $this->authentication->getUser();

             //#N7 5/8/22 A.Flores NEW 1L: if id is set then find joke by id and check if joke's authorId does not equal to author's id
		if (isset($_GET['id'])) {
			$joke = $this->jokesTable->findById($_GET['id']);

			if ($joke['authorId'] != $author['id']) {
				return;
			}
		}

		$joke = $_POST['joke'];
		$joke['jokedate'] = new \DateTime();
		     //#N8 5/8/22 A.Flores NEW 1L: set joke author's ID to author's id 
		$joke['authorId'] = $author['id'];

		$this->jokesTable->save($joke);
		//header('location: /joke/list'); 5/25/18 JG DEL1L  org
		header('location: index.php?joke/list');  //5/25/18 JG NEW1L  
		
	}
         //#P6 5/8/22 A.Flores NEW 18L: edit() function is use to display the joke the user selected to edit on editjoke.html.php
	public function edit() {
		$author = $this->authentication->getUser();

		if (isset($_GET['id'])) {
			$joke = $this->jokesTable->findById($_GET['id']);
			     //5/8/22 A.Flores NEW 2L: Added two additional trace outputs to display author and joke ID.
			print ('joke.php: 106 authorId ='.$joke['authorId']. '<br>');
			print ('joke.php: 107 Joke ID ='.$joke['id']. '<br>');
		}

		$title = 'Edit joke';

		return ['template' => 'editjoke.html.php',
				'title' => $title,
				'variables' => [
						'joke' => $joke ?? null,
					//#N9 5/8/22 A.Flores NEW 1L: set the userId variable in the template to null when no user is logged in.
						'userId' => $author['id'] ?? null
					]
				];
	}
}