<?php
namespace Ijdb\Controllers;
     //#N1 5/8/22 A.Flores NEW 45L: Login class is a controller that includes functions for login 
class Login {
	private $authentication;
         //#P1 5/8/22 A.Flores NEW 3L: constructor function initializes $authentication
	public function __construct(\Ninja\Authentication $authentication) {
		$this->authentication = $authentication;
	}
		 //#N2 5/8/22 A.Flores NEW 3L: added loginForm() function returns login template and title
         //#P2 5/8/22 A.Flores NEW 3L: loginForm() function returns login template and title
	public function loginForm() {
		return ['template' => 'login.html.php', 'title' => 'Log In'];
	}
		 //#N3 5/8/22 A.Flores NEW 15L: added processLogin() function processes the form and returns an error if information is incorrect
	     //#P3 5/8/22 A.Flores NEW 15L: processLogin() function processes the form and returns an error if information is incorrect
	public function processLogin() {
		if ($this->authentication->login($_POST['email'], $_POST['password'])) {
			//header('Location: /login/success'); //5/25/18 JG DEL1L  org
            header('Location: index.php?login/success'); //5/25/18 JG NEW1L  
			
		}
		else {
			return ['template' => 'login.html.php',
					'title' => 'Log In',
					'variables' => [
							'error' => 'Invalid username/password.'
						]
					];
		}
	}
	     //#N4 5/8/22 A.Flores NEW 6L: success() and error() functions returns a template and title
         //#P4 5/8/22 A.Flores NEW 3L: success() function returns login success template and title
	public function success() {
		return ['template' => 'loginsuccess.html.php', 'title' => 'Login Successful'];
	}
         //#P5 5/8/22 A.Flores NEW 3L: error() function returns login error template and title
	public function error() {
		return ['template' => 'loginerror.html.php', 'title' => 'You are not logged in'];
	}
	     //#N5 5/8/22 A.Flores NEW 1L: added logout() function destroys session and returns logout template and title 
         //#P6 5/8/22 A.Flores NEW 5L: logout() function destroys session and returns logout template and title
	public function logout() {
	    unset($_SESSION);  //5/26/18 JG org DEL1l - it doesn't delete all session info
		session_destroy(); //5/26/18 JG NEW1l  to kill all session information
		return ['template' => 'logout.html.php', 'title' => 'You have been logged out'];
	}
}
