<?php
namespace Ijdb\Controllers;
use \Ninja\DatabaseTable;
     //#N1 5/8/22 A.Flores NEW 82L: Register class gives the functionality for registering 
class Register {
	private $authorsTable;
         //#P1 5/8/22 A.Flores NEW 3L: A constructor to the Register class that sets the $authorsTable variable
	public function __construct(DatabaseTable $authorsTable) {
		$this->authorsTable = $authorsTable;
	}
         //#P2 5/8/22 A.Flores NEW 4L: registrationForm() function returns the register template and title
	public function registrationForm() {
		return ['template' => 'register.html.php', 
				'title' => 'Register an account'];
	}

         //#P3 5/8/22 A.Flores NEW 4L: success() function returns the register success template and title
	public function success() {
		return ['template' => 'registersuccess.html.php', 
			    'title' => 'Registration Successful'];
	}
         //#P4 5/8/22 A.Flores NEW 63L: registerUser() function registers the user and includes error handling
	public function registerUser() {
		$author = $_POST['author'];

		//Assume the data is valid to begin with
		$valid = true;
		$errors = [];
             //#P5 5/8/22 A.Flores NEW 55L: if and else statements use to check for errors for name, email, and username.
		//But if any of the fields have been left blank, set $valid to false
		if (empty($author['name'])) {
			$valid = false;
			$errors[] = 'Name cannot be blank';
		}
			//#N2 5/8/22 A.Flores NEW 24L: if fields are empty or incorrect then add error to array.
		if (empty($author['email'])) {
			$valid = false;
			$errors[] = 'Email cannot be blank';
		}
		else if (filter_var($author['email'], FILTER_VALIDATE_EMAIL) == false) {
			$valid = false;
			$errors[] = 'Invalid email address';
		}
		else { //if the email is not blank and valid:
			//convert the email to lowercase
			$author['email'] = strtolower($author['email']);

			//search for the lowercase version of `$author['email']`
			if (count($this->authorsTable->find('email', $author['email'])) > 0) {
				$valid = false;
				$errors[] = 'That email address is already registered';
			}
		}


		if (empty($author['password'])) {
			$valid = false;
			$errors[] = 'Password cannot be blank';
		}
             //#N3 5/8/22 A.Flores NEW 13L: If $valid is true, then add the data
		//If $valid is still true, no fields were blank and the data can be added
		if ($valid == true) {
			//Hash the password before saving it in the database
			$author['password'] = password_hash($author['password'], PASSWORD_DEFAULT);

			//When submitted, the $author variable now contains a lowercase value for email
			//and a hashed password
			$this->authorsTable->save($author);

            //header('Location: /author/success'); //5/25/18 JG DEL1L  org
            header('Location: index.php?author/success'); //5/25/18 JG NEW1L  


		}
		else {
			//If the data is not valid, show the form again
			return ['template' => 'register.html.php', 
				    'title' => 'Register an account',
				    'variables' => [
				    	'errors' => $errors,
				    	'author' => $author
				    ]
				   ]; 
		}
	}
}