<?php
namespace Ijdb;

class IjdbRoutes implements \Ninja\Routes {
	private $authorsTable;
	private $jokesTable;
	private $authentication;
	     //#N1 5/8/22 A.Flores NEW 7L: Added constructor method is use to intialize DatabaseTable and Authentication objects  
         //#P1 5/8/22 A.Flores NEW 7L: constructor method is use to intialize DatabaseTable and Authentication objects 
	public function __construct() {
		include __DIR__ . '/../../includes/DatabaseConnection.php';

		$this->jokesTable = new \Ninja\DatabaseTable($pdo, 'joke', 'id');
		$this->authorsTable = new \Ninja\DatabaseTable($pdo, 'author', 'id');
		     //#N2 5/8/22 A.Flores NEW 1L: intialize Authentication object
		$this->authentication = new \Ninja\Authentication($this->authorsTable, 'email', 'password');
	}
         //#P2 5/8/22 A.Flores NEW 85L: getRoutes() method is use to intialize objects and return $routes array
	public function getRoutes(): array {
		$jokeController = new \Ijdb\Controllers\Joke($this->jokesTable, $this->authorsTable, $this->authentication);
		$authorController = new \Ijdb\Controllers\Register($this->authorsTable);
		$loginController = new \Ijdb\Controllers\Login($this->authentication);
		 //#N3 5/8/22 A.Flores MOD 77L: Added routes login error and success, logout and login into $routes array 
         //#P3 5/8/22 A.Flores NEW 77L: array $routes stores the informtion for each route 
		$routes = [
			'author/register' => [
				'GET' => [
					'controller' => $authorController,
					'action' => 'registrationForm'
				],
				'POST' => [
					'controller' => $authorController,
					'action' => 'registerUser'
				]
			],
			'author/success' => [
				'GET' => [
					'controller' => $authorController,
					'action' => 'success'
				]
			],
			'joke/edit' => [
				'POST' => [
					'controller' => $jokeController,
					'action' => 'saveEdit'
				],
				'GET' => [
					'controller' => $jokeController,
					'action' => 'edit'
				],
				'login' => true
				
			],
			'joke/delete' => [
				'POST' => [
					'controller' => $jokeController,
					'action' => 'delete'
				],
				'login' => true
			],
			'joke/list' => [
				'GET' => [
					'controller' => $jokeController,
					'action' => 'list'
				]
			],
			'login/error' => [
				'GET' => [
					'controller' => $loginController,
					'action' => 'error'
				]
			],
			'login/success' => [
				'GET' => [
					'controller' => $loginController,
					'action' => 'success'
				]
			],
			'logout' => [
				'GET' => [
					'controller' => $loginController,
					'action' => 'logout'
				]
			],
			'login' => [
				'GET' => [
					'controller' => $loginController,
					'action' => 'loginForm'
				],
				'POST' => [
					'controller' => $loginController,
					'action' => 'processLogin'
				]
			],
			'' => [
				'GET' => [
					'controller' => $jokeController,
					'action' => 'home'
				]
			]
		];

		return $routes;
	}
	     //#N4 5/8/22 A.Flores NEW 3L: added getAuthentication() function that returns authentication object 
         //#P4 5/8/22 A.Flores NEW 3L:  getAuthentication() function returns authentication object
	public function getAuthentication(): \Ninja\Authentication {
		return $this->authentication;
	}

}