<?php

namespace Ninja;
     //#N1 5/8/22 A.Flores NEW 53L: Authentication class has the functionality for logging in
class Authentication {
	private $users;
	private $usernameColumn;
	private $passwordColumn;
         //#N2 5/8/22 A.Flores NEW 6L: constructor intialize values
	public function __construct(DatabaseTable $users, $usernameColumn, $passwordColumn) {
		session_start();
		$this->users = $users;
		$this->usernameColumn = $usernameColumn;
		$this->passwordColumn = $passwordColumn;
	}
         //#N3 5/8/22 A.Flores NEW 13L: login() method sets session username and password and returns true or false
	public function login($username, $password) {
		$user = $this->users->find($this->usernameColumn, strtolower($username));

		if (!empty($user) && password_verify($password, $user[0][$this->passwordColumn])) {
			session_regenerate_id();
			$_SESSION['username'] = $username;
			$_SESSION['password'] = $user[0][$this->passwordColumn];
			return true;
		}
		else {
			return false;
		}
	}
         //#N4 5/8/22 A.Flores NEW 14L: isLoggedIn() method checks if user is login or not 
	public function isLoggedIn() {
		if (empty($_SESSION['username'])) {
			return false;
		}
		
		$user = $this->users->find($this->usernameColumn, strtolower($_SESSION['username']));

		if (!empty($user) && $user[0][$this->passwordColumn] === $_SESSION['password']) {
			return true;
		}
		else {
			return false;
		}
	}
         //#N5 5/8/22 A.Flores NEW 11L: getUser() method returns ID of the logged-in user or false
	     //5/26/18 get the ID of the logged-in user
	public function getUser() {
		if ($this->isLoggedIn()) {
			     //5/8/22 A.Flores NEW 2L: Added two additional trace outputs to display username and password.
			print ('Authentication.php: 50 username = ' . $_SESSION['username'] . '<br>');  
			print ('Authentication.php: 51 password = ' . $_SESSION['password'] . '<br>');  
			return $this->users->find($this->usernameColumn, strtolower($_SESSION['username']))[0];
		}
		else {
			return false;
		}
	}
}