<?php
namespace Ninja;

class DatabaseTable {
	private $pdo;
	private $table;
	private $primaryKey;
         //#P1 5/8/22 A.Flores NEW 5L: A constructor to the DatabaseTable class that sets the $pdo, $table and $primaryKey variables: 
	public function __construct(\PDO $pdo, string $table, string $primaryKey) {
		$this->pdo = $pdo;
		$this->table = $table;
		$this->primaryKey = $primaryKey;
	}
	     //#P2 5/8/22 A.Flores  NEW 5L: query function is use to execute a sql query with $parameters and returns the results
	private function query($sql, $parameters = []) {
		$query = $this->pdo->prepare($sql);
		$query->execute($parameters);
		return $query;
	}	
         //#P3 5/8/22 A.Flores  NEW 5L: Use a query to find the total number of records in a table
	public function total() {
		$query = $this->query('SELECT COUNT(*) FROM `' . $this->table . '`');
		$row = $query->fetch();
		return $row[0];
	}
         //#P4 5/8/22 A.Flores  NEW 11L: This function uses a query to find a record by using its primary key and returns the record
	public function findById($value) {
		$query = 'SELECT * FROM `' . $this->table . '` WHERE `' . $this->primaryKey . '` = :value';

		$parameters = [
			'value' => $value
		];

		$query = $this->query($query, $parameters);

		return $query->fetch();
	}
	     //#N1 5/8/22 A.Flores NEW 11L: added find() function uses column to find values and returns the record
	     //#P5 5/8/22 A.Flores  NEW 11L: find function uses column to find values and returns the record
	public function find($column, $value) {
		$query = 'SELECT * FROM ' . $this->table . ' WHERE ' . $column . ' = :value';

		$parameters = [
			'value' => $value
		];

		$query = $this->query($query, $parameters);

		return $query->fetchAll();
	}
         //#P6 5/8/22 A.Flores  NEW 24L: insert function uses $fields and a query to insert a record to a table  
	private function insert($fields) {
		$query = 'INSERT INTO `' . $this->table . '` (';

		foreach ($fields as $key => $value) {
			$query .= '`' . $key . '`,';
		}

		$query = rtrim($query, ',');

		$query .= ') VALUES (';


		foreach ($fields as $key => $value) {
			$query .= ':' . $key . ',';
		}

		$query = rtrim($query, ',');

		$query .= ')';

		$fields = $this->processDates($fields);

		$this->query($query, $fields);
	}

	     //#P7 5/8/22 A.Flores  NEW 16L: update function uses $fields and a query to update a record from a table 
	private function update($fields) {
		$query = ' UPDATE `' . $this->table .'` SET ';

		foreach ($fields as $key => $value) {
			$query .= '`' . $key . '` = :' . $key . ',';
		}

		$query = rtrim($query, ',');

		$query .= ' WHERE `' . $this->primaryKey . '` = :primaryKey';

		//Set the :primaryKey variable
		$fields['primaryKey'] = $fields['id'];

		$fields = $this->processDates($fields);

		$this->query($query, $fields);
	}

         //#P8 5/8/22 A.Flores  NEW 5L: delete function is uses $id and a query to delete a record from a table
	public function delete($id ) {
		$parameters = [':id' => $id];

		$this->query('DELETE FROM `' . $this->table . '` WHERE `' . $this->primaryKey . '` = :id', $parameters);
	}

         //#P9 5/8/22 A.Flores  NEW 5L: findAll() function is use to fetch all records from a table and return them
	public function findAll() {
		$result = $this->query('SELECT * FROM ' . $this->table);

		return $result->fetchAll();
	}
         //#P10 5/8/22 A.Flores  NEW 9L: This function finds values that are instanceof DateTime and formats those values
	private function processDates($fields) {
		foreach ($fields as $key => $value) {
			if ($value instanceof \DateTime) {
				$fields[$key] = $value->format('Y-m-d');
			}
		}

		return $fields;
	}

         //#P11 5/8/22 A.Flores  NEW 11L: Save function is use to save records 
	public function save($record) {
		try {
			if ($record[$this->primaryKey] == '') {
				$record[$this->primaryKey] = null;
			}
			$this->insert($record);
		}
		catch (\PDOException $e) {
			$this->update( $record);
		}
	}
}