<?php
namespace Ijdb\Controllers;

class Login {
	private $authentication;

	public function __construct(\Ninja\Authentication $authentication) {
		$this->authentication = $authentication;
	}

	public function loginForm() {
		return ['template' => 'login.html.php', 'title' => 'Log In'];
	}

	public function processLogin() {
		
		  print ('Login.php: processlogin() L:17 user email = ' . $_POST['email'] . '<br>'); //5/16/22 JG 
		  print ('Login.php: processlogin() L:18 user password = ' . $_POST['password'] . '<br>'); //5/16/22 JG
		if ($this->authentication->login($_POST['email'], $_POST['password'])) {
			
			//header('Location: /login/success'); //5/25/18 JG DEL1L  org
            header('Location: index.php?login/success'); //5/25/18 JG NEW1L  
           return ['template' => 'loginsuccess.html.php', 'title' => 'Login Successful'];	//5/25/21 NEW 1L: JG 
		     //to avoid complain $templateFileName = null and $page empty. loadTemplate($templateFileName,$variables) throws the exception 
		}
		else {
			return ['template' => 'login.html.php',
					'title' => 'Log In',
					'variables' => [
							'error' => 'Invalid username/password.'
						]
					];
		}
	}

	public function success() {
		return ['template' => 'loginsuccess.html.php', 'title' => 'Login Successful'];
	}

	public function error() {
		return ['template' => 'loginerror.html.php', 'title' => 'You are not logged in'];
	}

	public function permissionsError() {
		return ['template' => 'permissionserror.html.php', 'title' => 'Access Denied'];
	}

	public function logout() {
		unset($_SESSION);
		session_destroy();
		return ['template' => 'logout.html.php', 'title' => 'You have been logged out'];
	}
}
