<?php
namespace Ninja;

class EntryPoint {
	private $route;
	private $method;
	private $routes;

	public function __construct(string $route, string $method, \Ninja\Routes $routes) {
		$this->route = $route;
		$this->routes = $routes;
		$this->method = $method;
		$this->checkUrl();
	}

	private function checkUrl() {
		if ($this->route !== strtolower($this->route)) {
			http_response_code(301);
			header('location: ' . strtolower($this->route));
		}
	}

	private function loadTemplate($templateFileName, $variables = []) {
		extract($variables);

		ob_start();
		include  __DIR__ . '/../../templates/' . $templateFileName;

		return ob_get_clean();
	}

	public function run() {

		  $routes = $this->routes->getRoutes();	
               print (' EntryPoint.php run() : 35 $this->route = ' . $this->route . '<br>');  // JG test
	           print (' EntryPoint.php run() : 36 $this->method = ' . $this->method . '<br>');  // JG test
	      $authentication = $this->routes->getAuthentication();
	          print (' EntryPoint.php run() : 38 LoggedIn = ' . $authentication->isLoggedIn() . '<br>');  // JG test
       	      print (' EntryPoint.php run() : 39 login = ' . isset($routes[$this->route]['login']) . '<br>');  // JG test


		if (isset($routes[$this->route]['login']) && !$authentication->isLoggedIn()) {
			print (' EntryPoint.php run() : 43 login = ' . 'not login'. '<br>');  // JG test
		  //header('location: /login/error');  // 5/25/18 JG DEL1L  org
	      header('location: index.php?login/error'); // 5/25/18 JG NEW1L  

		}
		else if (isset($routes[$this->route]['permissions']) && !$this->routes->checkPermission($routes[$this->route]['permissions'])) {
			//header('location: /login/permissionserror'); 6/3/18 JG DEL1L 
			header('location: index.php?login/permissionserror'); // 6/3/18 JG NEW1L 
		}
		else {   // 6/7/18 JG 3 next key statements
			$controller = $routes[$this->route][$this->method]['controller'];
			$action = $routes[$this->route][$this->method]['action'];
			$page = $controller->$action();

			print (' EntryPoint.php : 57 action = ' . $action .'<br>'); //JG TST 9-4-19
			
			$title = $page['title'];

            print (' EntryPoint.php run() : 61 title = ' . $title . '<br>'); //JG TST 9-4-19
            print (' EntryPoint.php run() : 62 template = ' . $page['template'] .'<br>');
                                                       			//JG TST 9-4-19
            
			if (isset($page['variables'])) {
				$output = $this->loadTemplate($page['template'], $page['variables']);
			}
			else {
				$output = $this->loadTemplate($page['template']);
			}
              // 9-5-19 display website with $output and $title
			echo $this->loadTemplate('layout.html.php', ['loggedIn' => $authentication->isLoggedIn(), 
			'output' => $output,	                                             'title' => $title]);

		}

	}
}