-- MySQL
--
-- Host: 127.0.0.1    Database: PHYSICAL_MEDIA_REVIEWS
-- ------------------------------------------------------


DROP TABLE IF EXISTS `category`;
CREATE TABLE `category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;


-- --------------------------------------------------------
--
-- Table structure for table `client`
--
DROP TABLE IF EXISTS `client`;
CREATE TABLE `client` (
  `id` int(11) AUTO_INCREMENT,
  `firstName` varchar(255)DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `permissions` int(64) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
)  ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `title`;
CREATE TABLE `title` (
  `id` int(11) AUTO_INCREMENT,
  `titletext` text,
  `releasedate` date NOT NULL,
  `averagerate` int(255) NOT NULL,
  `commentdate` date NOT NULL,
  `clientId` int(11) DEFAULT NULL,
  PRIMARY KEY(`id`),
  FOREIGN KEY (clientId) REFERENCES client(id)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8;

--
-- Table structure for table `category`
--

DROP TABLE IF EXISTS `titlecategory`;
CREATE TABLE `titlecategory` (
  `titleId` int(11) NOT NULL,
  `categoryId` int(11) NOT NULL,
  PRIMARY KEY (`titleId`,`categoryId`),
  FOREIGN KEY (titleId) REFERENCES title (id),          /* 6/5/18 JG NEW 1L: added definition of FOREIGN KEY field */
  FOREIGN KEY (categoryId) REFERENCES category (id)  /* 6/5/18 JG NEW 1L: added definition of FOREIGN KEY field */
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS `review`;
CREATE TABLE `review` (
  `id` int(11) NOT NULL,
  `titleId` int(11) NOT NULL,
  `clientId` int(11) DEFAULT NULL,
  `description` varchar(255) NOT NULL,
  `rate` int(20) NOT NULL,
  `date` date NOT NULL,
FOREIGN KEY (titleId) REFERENCES title(id),
FOREIGN KEY (clientId) REFERENCES client(id)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8;



-- --------------------------------------------------------





