<div class="jokelist">

<ul class="categories">
  <?php foreach($categories as $category): ?>
    <!-- <li><a href="/joke/list?category=<//?=$category->id?>"><//?=$category->name?></a><li> JG 6/3/18 org-->
	<li><a href="index.php?joke/list?category=<?=$category->id?>"><?=$category->name?></a><li> <!--  6/3/18 JG MOD1L -->
  <?php endforeach; ?>
</ul>

<div class="jokes">

<p><?=$totalJokes?> jokes have been submitted to the Internet Joke Database.</p>


<?php foreach($jokes as $joke): ?>
<blockquote>
  <?=(new \Ninja\Markdown($joke->joketext))->toHtml()?>

    (by <a href="mailto:<?=htmlspecialchars($joke->getAuthor()->email, ENT_QUOTES,
                    'UTF-8'); ?>">
                <?=htmlspecialchars($joke->getAuthor()->name, ENT_QUOTES,
                    'UTF-8'); ?></a> on 
<?php
$date = new DateTime($joke->jokedate);

echo $date->format('jS F Y');
?>)

<?php if ($user): ?>
  <?php if ($user->id == $joke->authorId || $user->hasPermission(\Ijdb\Entity\Author::EDIT_JOKES)): ?>
  <!--  <a href="/joke/edit?id=<//?=$joke->id?>">Edit</a> JG 6/3/18 org-->
  <a href="index.php?joke/edit?id=<?=$joke->id?>">Edit</a> <!--  6/3/18 JG MOD1L -->
  <?php endif; ?>
  <?php if ($user->id == $joke->authorId || $user->hasPermission(\Ijdb\Entity\Author::DELETE_JOKES)): ?>
  <!--  <form action="/joke/delete" method="post"> JG 6/3/18 org-->
  <form action="index.php?joke/delete" method="post"> <!-- / 6/3/18 JG MOD1L -->
    <input type="hidden" name="id" value="<?=$joke->id?>">
    <input type="submit" value="Delete">
  </form>
  <?php endif; ?>
<?php endif; ?>
</blockquote>
<?php endforeach; ?>

<!-- Select page: 6/8/18 JG don't display if no jokes -->
<?php echo $totalJokes ?'Select page:': ''?> <!--  6/8/18 JG NEW 1L Improve: don't display 'Select page' if no jokes -->

<?php
   // 7/6/18 JG display page numbers e.g. [1] 2 3
$numPages = ceil($totalJokes/10);

for ($i = 1; $i <= $numPages; $i++):
  if ($i == $currentPage):
?>
  <!-- <a class="currentpage" href="/joke/list?page=<//?=$i?><//?=!empty($categoryId) ? '&category=' . $categoryId : '' ?>"><//?=$i?></a> JG 6/3/18 org-->
  <a class="currentpage" href="index.php?joke/list?page=<?=$i?><?=!empty($categoryId) ? '&category=' . $categoryId : '' ?>"><?=$i?></a> <!--  6/3/18 JG MOD1L -->
<?php else: ?>
  <!-- <a href="/joke/list?page=<//?=$i?><//?=!empty($categoryId) ? '&category=' . $categoryId : '' ?>"><//?=$i?></a> JG 6/3/18 org-->
  <a href="index.php?joke/list?page=<?=$i?><?=!empty($categoryId) ? '&category=' . $categoryId : '' ?>"><?=$i?></a> <!--  6/3/18 JG MOD1L -->
<?php endif; ?>
<?php endfor; ?>

</div>
