<?php
function loadTemplate($templateFileName, $variables = []) {
	extract($variables);

	ob_start();
	include  __DIR__ . '/../templates/' . $templateFileName;

	return ob_get_clean();
}


try { 
	include __DIR__ . '/../includes/DatabaseConnection.php';
	include __DIR__ . '/../classes/DatabaseTable.php';
	include __DIR__ . '/../classes/controllers/JokeController.php';


	$jokesTable = new DatabaseTable($pdo, 'joke', 'id');
	$authorsTable = new DatabaseTable($pdo, 'author', 'id');
	
	$jokeController = new JokeController($jokesTable, $authorsTable);
	
	
	//$action = $_GET['action'] ?? 'home';  //5/4/18 JG DEL 1L:for php < v7
	$action = isset($_GET['action']) ? $_GET['action'] : 'home'; //5/4/18 JG MOD 1L:for php < v7
	
	
	//print ('index.php:l28:'.$action .'<br>');  // test
	$page = $jokeController->$action();

	$title = $page['title'];
    //print ('index.php: l32:'. $title . '<br>');  // test	

	if (isset($page['variables'])) {
		$output = loadTemplate($page['template'], $page['variables']);
	}
	else {
		$output = loadTemplate($page['template']);
	}
   
}
catch (PDOException $e) {
	$title = 'An error has occurred';

	$output = 'Database error: ' . $e->getMessage() . ' in ' .
	$e->getFile() . ':' . $e->getLine();
}

include  __DIR__ . '/../templates/layout.html.php';