<?php
namespace Ninja;

class Authentication {
	private $users;
	private $usernameColumn;
	private $passwordColumn;

	public function __construct(DatabaseTable $users, $usernameColumn, $passwordColumn) {
		session_start();
		$this->users = $users;
		$this->usernameColumn = $usernameColumn;
		$this->passwordColumn = $passwordColumn;
	}

	public function login($username, $password) {
		$user = $this->users->find($this->usernameColumn, strtolower($username));
		
		  print ('Authentication.php: login() L:19 username = ' . $username . '<br>');  //5/16/22 JG
		  print ('Authentication.php: login() L:20 passed password = ' . $password . '<br>'); 	//5/16/22 JG	  
		
		if (!empty($user) && password_verify($password, $user[0]->{$this->passwordColumn})) {
			session_regenerate_id();
			$_SESSION['username'] = $username;
			$_SESSION['password'] = $user[0]->{$this->passwordColumn};
			
              print ('Authentication.php: login() L:27 password = ' . $user[0]->{$this->passwordColumn} . '<br>'); //5/16/22 JG
			
			return true;
		}
		else {
			return false;
		}
	}

	public function isLoggedIn() {
		if (empty($_SESSION['username'])) {
			return false;
		}
		
		$user = $this->users->find($this->usernameColumn, strtolower($_SESSION['username']));
            
		if (!empty($user) && $user[0]->{$this->passwordColumn} === $_SESSION['password']) {
		    
			  print ('Authentication.php: isLoggedIn() L:45 username = ' . $_SESSION['username'] . '<br>');  //5/16/22 JG
			  print ('Authentication.php: isLoggedIn() L:46 password = ' . $_SESSION['password'] . '<br>');  //5/16/22 JG
			
			return true;
		}
		else {
			return false;
		}
	}
	
	public function getUser() {
		if ($this->isLoggedIn()) {
			return $this->users->find($this->usernameColumn, strtolower($_SESSION['username']))[0];
		}
		else {
			return false;
		}
	}
}