<?php
class EntryPoint {
	private $route;
	private $routes;

	public function __construct($route, $routes) {
		$this->route = $route;		
		$this->routes = $routes;
		//$this->checkUrl(); //5/13/18 DEL 1L: causes a problem: The requested URL was not found on this server.
	}

	
	
	private function checkUrl() {
		
		if ($this->route !== strtolower($this->route)) {
			http_response_code(301);
			header('location: ' . strtolower($this->route));
		}
	}

	private function loadTemplate($templateFileName, $variables = []) {
		extract($variables);

		ob_start();
		include  __DIR__ . '/../templates/' . $templateFileName;

		return ob_get_clean();
	}

	public function run() {

	    print ('EntryPoint.php:33 route = ' . $this->route . '<br>');  // test
	    $page = $this->routes->callAction($this->route); 
		
		print ('EntryPoint.php:36 title = ' . $page['title'] . '<br>');  // test
		$title = $page['title'];

		if (isset($page['variables'])) {
			$output = $this->loadTemplate($page['template'], $page['variables']);
		}
		else {
			$output = $this->loadTemplate($page['template']);
		}
        //print ('EntryPoint.php: 44 output = ' . $output . '<br>');  // test
		include  __DIR__ . '/../templates/layout.html.php';
	}
}