<?php
class IjdbRoutes {
	public function callAction($route) {
		include __DIR__ . '/../classes/DatabaseTable.php';
		include __DIR__ . '/../includes/DatabaseConnection.php';

		$jokesTable = new DatabaseTable($pdo, 'joke', 'id');
		$authorsTable = new DatabaseTable($pdo, 'author', 'id');
		
		print ('JijdbRoutes.php:10 route = ' . $route .'<br>');  // test
		print ('JijdbRoutes.php:11 __DIR__  = ' .__DIR__ .'<br>');
		
		//if ($route === 'joke/list') { JG
        if ($route === '?joke/list') { 			
			include __DIR__ . '/../classes/controllers/JokeController.php';
			$controller = new JokeController($jokesTable, $authorsTable);
			$page = $controller->list();
		}
		else if ($route === '') {
			include __DIR__ . '/../classes/controllers/JokeController.php';
			$controller = new JokeController($jokesTable, $authorsTable);
			print ('JijdbRoutes.php:20 DIR = ' . __DIR__.'<br>');  // test
			$page = $controller->home();
		}
		else if ($route === 'joke/edit') {
			include __DIR__ . '/../classes/controllers/JokeController.php';
			$controller = new JokeController($jokesTable, $authorsTable);
			$page = $controller->edit();
		}
		else if ($route === 'joke/delete') {
			include __DIR__ . '/../classes/controllers/JokeController.php';
			$controller = new JokeController($jokesTable, $authorsTable);
			$page = $controller->delete();
		}
		else if ($route === 'register') {
			include __DIR__ . '/../classes/controllers/RegisterController.php';
			$controller = new RegisterController($authorsTable);
			$page = $controller->showForm();
		}
        print ('ijdbRoutes.php: 38 template = ' . $page['template'] . '<br>');  // test
		return $page;
	}
}