<?php
namespace Ninja;

class EntryPoint {
	private $route;
	private $method;
	private $routes;

	public function __construct(string $route, string $method, \Ninja\Routes $routes) {
		$this->route = $route;
		$this->routes = $routes;
		$this->method = $method;
		$this->checkUrl(); //5/14/18 DEL 1L: causes a problem: The requested URL was not found on this server.
	}

	private function checkUrl() {
		if ($this->route !== strtolower($this->route)) {
			http_response_code(301);
			header('location: ' . strtolower($this->route));
		}
	}

	private function loadTemplate($templateFileName, $variables = []) {
		extract($variables);

		ob_start();
		include  __DIR__ . '/../../templates/' . $templateFileName;

		return ob_get_clean();
	}

	public function run() {

		$routes = $this->routes->getRoutes();

			print ('EntryPoint.php: 36 route = ' . $this->route . '<br>');  // test
			print ('EntryPoint.php: 37 method = ' . $this-> method. '<br>');  // test
			//print ('EntryPoint.php: 38 method = ' . $routes[$this->route][$this->method]. '<br>'); //test in loop			
			//$route =''; //test JG
		$controller = $routes[$this->route][$this->method]['controller'];
			//print ('EntryPoint.php: 41 controller = ' . $controller. '<br>');  // test	
		$action = $routes[$this->route][$this->method]['action'];
			//print ('EntryPoint.php: 43 action = ' . $action. '<br>');  
		$page = $controller->$action();

		$title = $page['title'];
       
		if (isset($page['variables'])) {
			$output = $this->loadTemplate($page['template'], $page['variables']);
		}
		else {
			$output = $this->loadTemplate($page['template']);
		}
        //print ('EntryPoint.php: 71 output = ' . $output. '<br>');  // test	
		include  __DIR__ . '/../../templates/layout.html.php';
	}
}