<?php
function loadTemplate($templateFileName, $variables) {
    extract($variables);

    ob_start();
    include  __DIR__ . '/../templates/' . $templateFileName;

    return ob_get_clean();
}

try {
    include __DIR__ . '/../includes/DatabaseConnection.php';
    include __DIR__ . '/../classes/DatabaseTable.php';
    include __DIR__ . '/../controllers/JokeController.php';

      //#P1 4/30/24 J.Goetz NEW 3L: Create two instances of DatabaseTable class 
	  // and an instances of JokeController class by using their constructors
    $jokesTable = new DatabaseTable($pdo, 'joke', 'id');
    $authorsTable = new DatabaseTable($pdo, 'author', 'id');

    $jokeController = new JokeController($jokesTable, $authorsTable);


       //#P2 4/30/24 J.Goetz NEW 6L:  $action is use to read GET variable called action if it is set. 
	   //$page is set to relevant method on the $jokeController object that was called.
	   //$title is use to store the page's title from the $page array
    $action = $_GET['action'] ?? 'home';

    print ('index.php:l/29: action = '.$action .'<br>');  // test1
    $page = $jokeController->$action();

    $title = $page['title'];
    print ('index.php: l/33: title = '. $title . '<br>');  // test2
	
	  //#P3 4/30/24 J.Goetz NEW 2L: Set $variables array and pass to loadTemplate() line 2 respectively. 
	  //If $page['variables'] is set then pass $page['variables'], else only template. 
    $variables = $page['variables'] ?? [];
    $output = loadTemplate($page['template'], $variables);

} catch (PDOException $e) {
    $title = 'An error has occurred';

    $output = 'Database error: ' . $e->getMessage() . ' in ' .
    $e->getFile() . ':' . $e->getLine();
}

include  __DIR__ . '/../templates/layout.html.php';